/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.platform.plugins;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.impactdev.impactor.api.platform.plugins.PluginDependency;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.impactdev.impactor.relocations.org.apache.maven.artifact.versioning.ArtifactVersion;
import net.impactdev.impactor.relocations.org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class PluginMetadata {
    private final String id;
    private final String name;
    private final ArtifactVersion version;
    private final String description;
    private final List<PluginDependency> dependencies;

    private PluginMetadata(PluginMetadataBuilder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.dependencies = builder.dependencies;
    }

    public String id() {
        return this.id;
    }

    public ArtifactVersion version() {
        return this.version;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public List<PluginDependency> dependencies() {
        return this.dependencies;
    }

    public static PluginMetadataBuilder builder() {
        return new PluginMetadataBuilder();
    }

    public static class PluginMetadataBuilder
    implements Builder<PluginMetadata> {
        private String id;
        private String name;
        private ArtifactVersion version;
        private String description;
        private final List<PluginDependency> dependencies = Lists.newArrayList();

        public PluginMetadataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PluginMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PluginMetadataBuilder version(String version) {
            this.version = new DefaultArtifactVersion(version);
            return this;
        }

        public PluginMetadataBuilder version(ArtifactVersion version) {
            this.version = version;
            return this;
        }

        public PluginMetadataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PluginMetadataBuilder dependencies(PluginDependency ... dependencies) {
            this.dependencies.addAll(Arrays.asList(dependencies));
            return this;
        }

        @Override
        public PluginMetadata build() {
            return new PluginMetadata(this);
        }
    }
}

